﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
    <HEAD>
        <title>Specyfikacja transportowa</title>
        <script runat="server">

    ParametryWydrukuDokumentuTransport parametry;
    [Context]
    public ParametryWydrukuDokumentuTransport Parametry {
        get { return parametry; }
        set { parametry = value; }
    }
    
    void OnContextLoad(Object sender, EventArgs args) {
        DataRepeater1.DataSource = (IEnumerable)Parametry;
        DokumentHandlowy dokument = Parametry.Dokument;
            
        DokumentHandlowy dokumentOpakowań = null;
        foreach( RelacjaHandlowa r in dokument.NadrzedneRelacje ) {
            if( r.Typ == TypRelacjiHandlowej.HandlowoMagazynowa ) {
                
                foreach( RelacjaHandlowa rr in r.Nadrzedny.PodrzedneRelacje ) {
                    if( rr.Typ == TypRelacjiHandlowej.Kaucji )
                        dokumentOpakowań = rr.Podrzedny;
                }
            }
        }

        bool sąOpakowania = dokumentOpakowań != null;

        SectionDokumentHandlowy.Visible = dokument.DokumentHandlowyNumer!="";
        SectionMagazyn.Visible = dokument.Magazyn!=null && dokument.MagazynDo==null;
        SectionMagazynDo.Visible = dokument.MagazynDo!=null;

        SectionOpakowania.Visible = sąOpakowania;
        if( sąOpakowania )
            GridOpakowania.DataSource = dokumentOpakowań.Pozycje;
        else
            GridOpakowania.DataSource = new PozycjaDokHandlowego[0];
    
        //Formatujemy informację o podmiocie
        if (dokument.Kontrahent==null)
            SectionKontrahent.Visible = false;
        else {
            if (dokument.Wydruk.JestOdbiorca)
                kto2.EditValue = "Kontrahent";
            else
                kto2.EditValue = dokument.Definicja.DostawcaOdbiorca;
        }
    
        //Składamy opis do dokumentu
        string opis = "";
        if (dokument.Opis!="")
            opis += "<p>" + dokument.Opis + "</p>";
        if (dokument.Wydruk.OpisWydruku!="")
            opis += "<p>" + dokument.Wydruk.OpisWydruku + "</p>";
        Opis.EditValue = opis;
        DataLabel16.EditValue = parametry.NrRejestracyjny;

        //Formatujemy podpisy
        stPodpis.Caption = "<font size=2>"+dokument.Session.Login.Operator.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
        stOsoba.Caption = "<font size=2>"+dokument.Osoba+"</font><br><br><font size=1>..................................................<br>Podpis kierowcy. Imie i nazwisko: </font>"+parametry.Kierowca;
    }
    
    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        //Formatujemy nagłówek dokumentu.
        //Może być za każdym razem inny
        KopiaDokumentuTransport kopia = (KopiaDokumentuTransport)DataRepeater1.CurrentRow;
        DokumentHandlowy dokument = kopia.Dokument;
        //string title = dokument.Definicja.TytulWydruku;
        string title = "Specyfikacja transportowa ";
        if (title!="")
            title += " ";
        title += dokument.Numer;
        if (dokument.Wydruk.OpisStanu!="")
            title += "|" + dokument.Wydruk.OpisStanu;

        if (dokument.Wydruk.Wystawiony_Do_20130101)
            title += "|" + kopia.Kopia;
        
        title += "|</STRONG>Data i miejsce wystawienia:<STRONG> " + dokument.Data + ", " + (dokument.Wydruk.JestOddzial ? dokument.Wydruk.PieczatkaOddziału.Adres.Miejscowosc : CoreModule.GetInstance(dokument).Config.Firma.AdresSiedziby.Miejscowosc);
        title += "|</STRONG>Data operacji:<STRONG> " + dokument.DataOperacji;
        if (kopia.Kopia==TypKopiiDokumentuTransport.Duplikat)
            title += "|</STRONG>Data wystawienia duplikatu:<STRONG> " + Date.Today;
    
        ReportHeader1.Title = title;
    }
    
        </script>
        <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
        <meta content="C#" name="CODE_LANGUAGE">
        <meta content="JavaScript" name="vs_defaultClientScript">
        <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    </HEAD>
    <body>
        <form id="Sprzedaż" method="post" runat="server">
            <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"></ea:datacontext>
            <ea:datarepeater id="DataRepeater1" runat="server" Height="397px" Width="100%" RowTypeName="Soneta.Handel.KopiaDokumentu,Soneta.Handel"
                OnBeforeRow="DataRepeater1_BeforeRow">
                <ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
                <ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
                <cc1:ReportHeader id="ReportHeader1" title="Specyfikacja Transportowa" runat="server"></cc1:ReportHeader>
                <ea:Section id="SectionDokumentHandlowy" runat="server" Width="100%">
                    <EM>
                        Dokument handlowy: </EM>
                    <ea:DataLabel id="DataLabel11" runat="server" DataMember="Dokument.DokumentHandlowyNumer" EncodeHTML="True"></ea:DataLabel>
                    <EM>&nbsp;z dnia:</EM>
                    <ea:DataLabel id="DataLabel13" runat="server" DataMember="Dokument.DokumentHandlowyData" EncodeHTML="True"></ea:DataLabel>
                    <br />
                </ea:Section>
                <ea:Section id="SectionMagazyn" runat="server" Width="100%">
                    <EM>Magazyn: </EM>
                    <ea:DataLabel id="DataLabel1" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
                    <BR>
                    <em>Numer Rejestracyjny: </em>
                        <ea:DataLabel id="DataLabel16" runat="server" EncodeHTML="True" Font-Bold="True" Font-Underline="True">
                        </ea:DataLabel>
                </ea:Section>
                <ea:Section id="SectionMagazynDo" runat="server" Width="100%">
                    <EM>Z magazynu: </EM>
                    <ea:DataLabel id="DataLabel2" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
                    <EM>Do magazynu: </EM>
                    <ea:DataLabel id="DataLabel3" runat="server" DataMember="Dokument.MagazynDo" EncodeHTML="True"></ea:DataLabel>
                    <BR>
                </ea:Section>
                <ea:Section id="SectionKontrahent" runat="server" Width="100%">
                    <EM>
                        <TABLE id="Table1" cellSpacing="0" width="100%">
                            <TR>
                                <TD vAlign="top" width="50%"><EM><U>
                                            <ea:DataLabel id="kto2" runat="server" Bold="False" Font-Italic="True" EncodeHTML="True"></ea:DataLabel>:<BR>
                                        </U></EM>
                                    <DIV style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
                                        <ea:DataLabel id="DataLabel4" runat="server" DataMember="Dokument.DaneKontrahenta.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><BR>
                                        <ea:DataLabel id="DataLabel5" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><BR>
                                        <ea:DataLabel id="DataLabel6" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><BR>
                                        NIP:
                                        <ea:DataLabel id="DataLabel12" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.EuVAT"></ea:DataLabel></DIV>
                                </TD>
                                <TD vAlign="top" width="100%">
                                    <ea:Section id="sectionOdbiorca" runat="server" DataMember="Dokument.Wydruk.JestOdbiorca">
                                        <EM><U>
                                                <ea:DataLabel id="kto" runat="server" Bold="False" Font-Italic="True" DataMember="Dokument.Definicja.DostawcaOdbiorca" EncodeHTML="True"></ea:DataLabel>:</U></EM>
                                        <DIV style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
                                            <ea:DataLabel id="DataLabel10" runat="server" DataMember="Dokument.DaneOdbiorcy.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><BR>
                                            <ea:DataLabel id="DataLabel9" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><BR>
                                            <ea:DataLabel id="DataLabel8" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><BR>
                                            NIP:
                                            <ea:DataLabel id="DataLabel7" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.EuVAT"></ea:DataLabel></DIV>
                                    </ea:Section>
                                    <ea:Section id="sectionMiejsceDostawy" runat="server" DataMember="Dokument.Wydruk.JestOdbiorcaMiejsceDostawy">
                                        <em style="text-decoration: underline;">Miejsce dostawy:</em>
                                        <div style="font-size: 13px; left: 10px; font-family: tahoma; position: relative">
                                            <ea:DataLabel runat="server" DataMember="Dokument.OdbiorcaMiejsceDostawy.Nazwa" EncodeHTML="True"></ea:DataLabel><br />
                                            <ea:DataLabel runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><br />
                                            <ea:DataLabel runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><br />
                                        </div>
                                    </ea:Section>
                                </TD>
                            </TR>
                        </TABLE>
                    </EM>
                </ea:Section>
                <ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                    DataMember="Dokument.Pozycje" RowsInRow="2">
                    <Columns>
                        <ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="2" runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn2" Width="15" DataMember="Towar.Kod" Caption="Kod towaru" RowSpan="2" EncodeHTML="True" runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn3" DataMember="NazwaPierwszaLinia" Caption="Nazwa towaru" EncodeHTML="True" runat="server" RowSpan="2"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn5" Width="10" RightBorder="None" Align="Right" DataMember="ZmianaIlości.Value" Caption="Ilość" RowSpan="2" runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn6" Width="5" Align="Center" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="2" runat="server"></ea:GridColumn>
                        <ea:GridColumn runat="server" RowSpan="2" DataMember="MasaJednostkowaNetto" Align="Right" Caption="Masa jednostk." Width="14" RightBorder="None"></ea:GridColumn>
                        <ea:GridColumn runat="server" Format="/" RightBorder="None" RowSpan="2" Width="1"></ea:GridColumn>
                        <ea:GridColumn runat="server" Align="Left" Caption="jm." DataMember="Towar.Jednostka" RowSpan="2" Width="5"></ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Masa netto" DataMember="MasaNetto" EncodeHTML="True" RowSpan="2" Total="Sum" Align="Center" Width="12"></ea:GridColumn>
                        <ea:GridColumn ID="Ilosc" runat="server" Caption="Ilość opakowań" RowSpan="2" Width="10"></ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Masa brutto" DataMember="MasaBrutto" EncodeHTML="True" RowSpan="2" Width="10" Total="Sum" Align="Center"></ea:GridColumn>
                    </Columns>
                </ea:Grid>
                    <br />
                    Podsumowanie ilości:
                    <ea:DataLabel id="DataLabel14" runat="server" Bold="False" DataMember="Dokument.Wydruk.PodsumowanieIlości">
                    </ea:DataLabel>
                    <br />
                    <ea:Section ID="SectionOpakowania" runat="server">
                        <br />
                        Opakowania:
                        <ea:Grid ID="GridOpakowania" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel" runat="server">
                        <Columns>
                            <ea:GridColumn DataMember="Towar.Nazwa" Caption="Nazwa opakowania" runat="server" Width="20"></ea:GridColumn>
                            <ea:GridColumn DataMember="Ilosc" Caption="Ilość" runat="server" Width="20"></ea:GridColumn>
                        </Columns>    
                        </ea:Grid>
                    
                    </ea:Section>


                    <ea:DataLabel id="Opis" runat="server" Bold="False"></ea:DataLabel>
                <br />
                <br />
                Kwituję odbiór towaru w ilości wg powyższej specyfikacji<br />
                    <cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                        <Subtitles>
                            <cc1:FooterSubtitle Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                            <cc1:FooterSubtitle Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                        </Subtitles>
                    </cc1:ReportFooter>
                <ea:SectionMarker id="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker>
            </ea:datarepeater>
            <P></P>
            <p>
            </p>
            <p>
            </p>
            <p>
            </p>
            <p>
            </p>
            <p>
            </p>
        </form>
    </body>
</HTML>

